# Ghana National Event Management Platform

A comprehensive, government-integrated event management system designed to transform Ghana's event ecosystem through secure, transparent, and engaging experiences for all stakeholders.

## 🌟 Overview

The Ghana National Event Management Platform serves as the central nervous system for events across the nation, providing:

- **Mandatory National Event Registry** - All public events must be registered
- **Government Oversight & Analytics** - Real-time visibility for security and policy decisions
- **Secure Payment Integration** - Ghana Mobile Money, Visa/Mastercard support
- **Safety & Emergency Response** - Integrated reporting system with emergency services
- **Interactive Features** - Chat rooms, feedback systems, and community engagement
- **Venue & Vendor Management** - Complete ecosystem for tourism industry

## 🚀 Key Features

### For Event Organizers
- ✅ Event creation and management
- ✅ Government approval workflow
- ✅ Integrated ticketing system
- ✅ Analytics and reporting
- ✅ Chat room moderation
- ✅ Vendor marketplace access

### For Government Officials
- ✅ Real-time event oversight dashboard
- ✅ Event approval and permit management
- ✅ Safety report monitoring
- ✅ Revenue and tax tracking
- ✅ Emergency response coordination
- ✅ Analytics and intelligence

### For Tourists & Attendees
- ✅ **Tourist Dashboard Portal** - Comprehensive user interface
- ✅ **Event Discovery & Booking** - Browse events with real-time availability
- ✅ **Secure Payment Options** - Mobile Money, Cards, Bank Transfer
- ✅ **Interactive Chat Rooms** - Event-specific discussions
- ✅ **Safety Reporting System** - Emergency incident reporting
- ✅ **Accommodation Booking** - Hotel reservations with ratings
- ✅ **Feedback & Reviews** - Rate events and share experiences
- ✅ **Profile Management** - Personal information and preferences
- ✅ **Booking History** - Track all reservations and tickets

### For Venue Owners & Vendors
- ✅ Venue registration and management
- ✅ Service provider marketplace
- ✅ Booking management
- ✅ Government verification badges
- ✅ Revenue tracking

## 🛠 Technology Stack

### Backend
- **PHP 8.0+** - Server-side logic
- **MySQL 8.0+** - Database management
- **JWT Authentication** - Secure token-based auth
- **RESTful APIs** - Clean API architecture

### Frontend
- **HTML5/CSS3** - Modern web standards
- **JavaScript (ES6+)** - Interactive functionality
- **Responsive Design** - Mobile-first approach
- **Font Awesome** - Icon library

### Payment Integration
- **Paystack** - Card payments
- **MTN Mobile Money** - Mobile payments
- **Vodafone Cash** - Mobile payments
- **AirtelTigo Money** - Mobile payments

### External Services
- **Ghana Card API** - Identity verification
- **Emergency Services** - Safety integration
- **Email/SMS** - Notifications

## 📋 Prerequisites

- **Web Server**: Apache 2.4+ or Nginx 1.18+
- **PHP**: 8.0 or higher
- **MySQL**: 8.0 or higher
- **Extensions**: PDO, cURL, JSON, OpenSSL
- **Composer**: For dependency management (optional)

## 🔧 Installation

### 1. Clone the Repository
```bash
git clone https://github.com/ghana-gov/event-management-platform.git
cd event-management-platform
```

### 2. Database Setup
```bash
# Create database
mysql -u root -p
CREATE DATABASE gh_tourist_app;
USE gh_tourist_app;

# Import schema
SOURCE database/schema.sql;
```

### 3. Configuration
```bash
# Copy and configure database settings
cp config/database.php.example config/database.php

# Update database credentials in config/database.php
```

### 4. Web Server Configuration

#### Apache (.htaccess)
```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
RewriteRule ^api/(.*)$ api/$1.php [QSA,L]
```

#### Nginx
```nginx
location /api/ {
    try_files $uri $uri/ /api/index.php?$query_string;
}
```

### 5. Permissions
```bash
# Set proper permissions
chmod 755 uploads/
chmod 755 logs/
chown -R www-data:www-data uploads/ logs/
```

## 🔑 API Configuration

### Payment Gateways
Update the following in `config/database.php`:

```php
// Paystack (for card payments)
const PAYSTACK_PUBLIC_KEY = 'pk_live_your_public_key';
const PAYSTACK_SECRET_KEY = 'sk_live_your_secret_key';

// MTN Mobile Money
const MTN_MOMO_API_KEY = 'your_mtn_api_key';

// Vodafone Cash
const VODAFONE_CASH_API_KEY = 'your_vodafone_api_key';
```

### Email Configuration
```php
// SMTP Settings
const SMTP_HOST = 'smtp.gmail.com';
const SMTP_PORT = 587;
const SMTP_USERNAME = 'your_email@gmail.com';
const SMTP_PASSWORD = 'your_app_password';
```

## 📚 API Documentation

### Authentication Endpoints
```
POST /api/auth/register     - User registration
POST /api/auth/login        - User login
GET  /api/auth/profile      - Get user profile
PUT  /api/auth/profile      - Update profile
POST /api/auth/logout       - User logout
```

### Event Management
```
GET  /api/events/list       - Get events list
GET  /api/events/details    - Get event details
POST /api/events/create     - Create new event
POST /api/events/approve    - Approve event (Gov only)
GET  /api/events/categories - Get event categories
```

### Tourist Dashboard APIs
```
GET  /api/tourist.php?action=stats           - Get user statistics
GET  /api/tourist.php?action=bookings        - Get user bookings
GET  /api/tourist.php?action=reviews         - Get user reviews
GET  /api/tourist.php?action=safety-reports  - Get safety reports
POST /api/tourist.php?action=book-event      - Book event ticket
POST /api/tourist.php?action=submit-review   - Submit event review
POST /api/tourist.php?action=safety-report   - Submit safety report
PUT  /api/tourist.php?action=update-profile  - Update user profile
```

### Accommodation Management
```
GET  /api/accommodations.php?action=list     - Get accommodations list
GET  /api/accommodations.php?action=search   - Search accommodations
GET  /api/accommodations.php?action=bookings - Get user bookings
POST /api/accommodations.php?action=book     - Book accommodation
POST /api/accommodations.php?action=add      - Add new accommodation
```

### Payment Processing
```
GET  /api/payments/methods  - Get payment methods
POST /api/payments/initialize - Initialize payment
POST /api/payments/verify   - Verify payment status
GET  /api/payments/history  - Payment history
```

### Safety & Emergency
```
POST /api/events/safety-report - Submit safety report
GET  /api/events/government-dashboard - Gov dashboard
```

## 🏗 Database Schema

### Core Tables
- `users` - User accounts and profiles
- `user_roles` - Role-based permissions
- `events` - Event information and status
- `venues` - Venue and location data
- `event_tickets` - Ticketing and registration
- `payment_transactions` - Payment processing
- `safety_reports` - Emergency and safety reports

### Government Tables
- `government_agencies` - Official agencies
- `event_permits` - Licensing and permits
- `analytics_events` - System analytics

## 🔐 Security Features

### Authentication & Authorization
- JWT token-based authentication
- Role-based access control (RBAC)
- Password hashing with bcrypt
- Rate limiting on API endpoints

### Data Protection
- SQL injection prevention (PDO prepared statements)
- XSS protection
- CSRF protection
- Input validation and sanitization

### Payment Security
- PCI DSS compliant payment processing
- Encrypted transaction data
- Webhook signature verification
- Secure API key management

## 👥 User Roles & Permissions

### Admin
- Complete system access
- User management
- System configuration
- All permissions

### Government Official
- Event approval/rejection
- Safety report management
- Analytics dashboard access
- Emergency response coordination

### Event Organizer
- Create and manage events
- View analytics
- Moderate chat rooms
- Manage tickets

### Venue Owner
- Manage venue listings
- View bookings
- Update facility information
- Handle accommodations

### Vendor
- Service provider registration
- Manage service offerings
- Handle bookings
- Portfolio management

### Tourist/Attendee
- Browse and book events
- Join chat rooms
- Submit feedback
- Report safety issues

## 🚀 Deployment

### Production Environment
1. **Server Requirements**
   - Ubuntu 20.04+ or CentOS 8+
   - 4GB RAM minimum
   - 50GB storage
   - SSL certificate

2. **Security Hardening**
   ```bash
   # Disable debug mode
   # Update all API keys
   # Enable HTTPS only
   # Configure firewall
   ```

3. **Performance Optimization**
   - Enable PHP OPcache
   - Configure MySQL query cache
   - Use CDN for static assets
   - Implement Redis for sessions

### Environment Variables
```bash
# Production settings
export APP_ENV=production
export DB_HOST=localhost
export DB_NAME=gh_tourist_app
export DB_USER=app_user
export DB_PASS=secure_password
```

## 📊 Monitoring & Analytics

### System Monitoring
- Error logging and tracking
- Performance metrics
- API usage statistics
- Security event monitoring

### Business Analytics
- Event registration trends
- Revenue tracking
- User engagement metrics
- Regional event distribution

## 🤝 Contributing

### Development Setup
1. Fork the repository
2. Create feature branch
3. Follow coding standards
4. Write tests for new features
5. Submit pull request

### Coding Standards
- PSR-12 for PHP code
- ESLint for JavaScript
- Consistent naming conventions
- Comprehensive documentation

## 📞 Support & Contact

### Technical Support
- **Email**: tech-support@ghtouristapp.gov.gh
- **Phone**: +233 (0) 302 123 456
- **Hours**: Monday-Friday, 8:00 AM - 6:00 PM GMT

### Emergency Contacts
- **Police**: 191
- **Fire Service**: 192
- **Ambulance**: 193
- **National Disaster**: 999

### Government Partners
- **Ministry of Tourism, Arts & Culture**
- **Ghana Police Service**
- **National Security**
- **Ghana Fire Service**

## 📄 License

This project is licensed under the Ghana Government Public License - see the [LICENSE.md](LICENSE.md) file for details.

## 🙏 Acknowledgments

- Ministry of Tourism, Arts & Culture
- Ghana Police Service
- National Security Secretariat
- All government partners and stakeholders
- The people of Ghana

---

**Built with ❤️ for the people of Ghana**

*Transforming Ghana's event ecosystem through technology, security, and transparency.*
