# 🇬🇭 Ghana National Event Management Platform - Setup Guide

## 📋 Prerequisites

- **XAMPP** (Apache + MySQL + PHP 7.4+)
- **Web Browser** (Chrome, Firefox, Safari, Edge)
- **Text Editor** (VS Code, Sublime, etc.)

## 🚀 Quick Start (5 Minutes)

### 1. Start XAMPP Services
1. Open **XAMPP Control Panel**
2. Start **Apache** service (click Start button)
3. Start **MySQL** service (click Start button)
4. Verify both show "Running" status

### 2. Create Database
1. Open browser → `http://localhost/phpmyadmin`
2. Click **"New"** in left sidebar
3. Database name: `gh_tourist_app`
4. Click **"Create"**

### 3. Import Database Schema
1. Select your `gh_tourist_app` database
2. Click **"Import"** tab
3. Choose file: `database/schema.sql` → Click **"Go"**
4. Choose file: `database/schema_updates.sql` → Click **"Go"**
5. Verify 28 tables were created

### 4. Test Application
1. Visit: `http://localhost/GHTouristApp/debug.php`
2. Check all status indicators are green ✅
3. Visit: `http://localhost/GHTouristApp/index.html`

## 🔧 Detailed Setup

### Database Configuration

The app is pre-configured for XAMPP defaults:
- **Host:** localhost
- **Username:** root  
- **Password:** (empty)
- **Database:** gh_tourist_app

If you need different settings, edit `config/database.php`:

```php
private $host = 'localhost';
private $db_name = 'gh_tourist_app';
private $username = 'root';
private $password = ''; // XAMPP default is empty
```

### Directory Permissions

The app will automatically create these directories:
- `logs/` - For error logging
- `uploads/` - For file uploads

Ensure your web server can write to these directories.

## 📱 Application URLs

| Page | URL | Description |
|------|-----|-------------|
| **Homepage** | `/index.html` | Landing page with login/register |
| **Events** | `/events.html` | Browse and book events |
| **Venues** | `/venues.html` | Find and book venues |
| **Dashboard** | `/dashboard.html` | User dashboard (role-based) |
| **Debug** | `/debug.php` | System diagnostics |

## 🔍 Troubleshooting

### Common Issues

#### ❌ Internal Server Error
**Cause:** Database connection failed
**Solution:**
1. Check XAMPP MySQL is running
2. Verify database exists: `gh_tourist_app`
3. Check `debug.php` for detailed error info

#### ❌ Database Connection Failed
**Cause:** Wrong credentials or missing database
**Solution:**
1. Open phpMyAdmin → Create database `gh_tourist_app`
2. Import `schema.sql` and `schema_updates.sql`
3. Check password in `config/database.php` (should be empty for XAMPP)

#### ❌ 404 Not Found
**Cause:** Incorrect URL or missing .htaccess
**Solution:**
1. Use full URLs: `http://localhost/GHTouristApp/index.html`
2. Verify `.htaccess` file exists in root directory

#### ❌ JavaScript Errors
**Cause:** API endpoints not accessible
**Solution:**
1. Check Apache is running
2. Test API directly: `http://localhost/GHTouristApp/api/events.php?action=categories`

### Debug Tools

#### 1. Debug Dashboard
Visit `http://localhost/GHTouristApp/debug.php` to:
- Test database connection
- View system status
- Check error logs
- Verify directory permissions

#### 2. Error Logs
Check `logs/app_YYYY-MM-DD.log` for detailed error information:
- Database connection issues
- API request failures
- PHP errors and warnings

#### 3. Browser Developer Tools
- **Console:** Check for JavaScript errors
- **Network:** Monitor API requests/responses
- **Application:** Verify localStorage for auth tokens

## 🎯 User Roles & Features

### 👤 Event Organizers
- Create and manage events
- View registration analytics
- Handle event approvals
- Access payment reports

### 🎫 Event Attendees  
- Browse and search events
- Book tickets and venues
- Join event chat rooms
- Rate and review events

### 🏢 Venue Owners
- Register venues and services
- Manage bookings and availability
- Update venue information
- View booking analytics

### 🏛️ Government Officials
- Monitor all events and venues
- Approve/reject registrations
- Access compliance reports
- Emergency response coordination

## 🔐 Security Features

- **JWT Authentication** - Secure token-based login
- **Role-based Access** - Different permissions per user type
- **Government Verification** - Official approval system
- **Payment Security** - Encrypted payment processing
- **Data Protection** - GDPR-compliant data handling

## 💳 Payment Integration

### Supported Payment Methods
- **Mobile Money:** MTN, Vodafone Cash, AirtelTigo
- **Cards:** Visa, Mastercard via Paystack/Flutterwave
- **Bank Transfer:** Direct bank payments

### Configuration
Update payment API keys in `config/database.php`:
```php
const PAYSTACK_PUBLIC_KEY = 'pk_test_your_key';
const PAYSTACK_SECRET_KEY = 'sk_test_your_key';
```

## 📊 Analytics & Reporting

The platform includes comprehensive analytics:
- **Event Performance** - Attendance, revenue, ratings
- **Venue Utilization** - Booking rates, popular venues
- **Government Insights** - Tourism statistics, compliance
- **Financial Reports** - Revenue tracking, tax calculations

## 🚀 Production Deployment

### Server Requirements
- **PHP 7.4+** with PDO MySQL extension
- **MySQL 5.7+** or MariaDB 10.2+
- **Apache/Nginx** with mod_rewrite
- **SSL Certificate** for HTTPS
- **Minimum 2GB RAM**, 10GB storage

### Production Checklist
- [ ] Update database credentials
- [ ] Set `APP_ENV` to `production`
- [ ] Configure SSL certificates
- [ ] Set up automated backups
- [ ] Configure email SMTP settings
- [ ] Update payment API keys (live keys)
- [ ] Set up monitoring and alerts
- [ ] Configure firewall rules
- [ ] Test all user workflows

### Environment Variables
Create `.env` file for production:
```
APP_ENV=production
DB_HOST=localhost
DB_NAME=gh_tourist_app
DB_USER=your_user
DB_PASS=your_password
JWT_SECRET=your-super-secret-key
```

## 📞 Support

For technical support or questions:
- **Documentation:** Check this guide and code comments
- **Debug Tool:** Use `/debug.php` for diagnostics
- **Logs:** Check `logs/` directory for error details
- **Database:** Use phpMyAdmin for database management

## 🎉 Success!

If you can access all pages without errors and see data loading properly, your Ghana National Event Management Platform is ready to serve the nation! 🇬🇭

---

**Version:** 1.0.0  
**Last Updated:** 2024  
**Platform:** Ghana National Event Management System
