<?php
/**
 * Add sample events for testing the organizer dashboard
 */

require_once 'config/database.php';

// Initialize database connection
$database = new Database();
$pdo = $database->getConnection();

try {
    // Check if events already exist for organizer ID 6
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM events WHERE organizer_id = ?");
    $stmt->execute([6]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result['count'] > 0) {
        echo "Events already exist for organizer ID 6. Count: " . $result['count'] . "\n";
        exit;
    }
    
    // Get a valid category ID
    $stmt = $pdo->query("SELECT id FROM event_categories LIMIT 1");
    $category = $stmt->fetch(PDO::FETCH_ASSOC);
    $categoryId = $category ? $category['id'] : 1;
    
    // Sample events data
    $sampleEvents = [
        [
            'title' => 'Accra Music Festival 2025',
            'description' => 'Annual music festival featuring local and international artists',
            'event_type' => 'entertainment',
            'start_datetime' => '2025-12-15 18:00:00',
            'end_datetime' => '2025-12-15 23:00:00',
            'max_attendees' => 5000,
            'ticket_price' => 50.00,
            'approval_status' => 'approved'
        ],
        [
            'title' => 'Ghana Cultural Heritage Exhibition',
            'description' => 'Showcasing Ghana\'s rich cultural heritage and traditions',
            'event_type' => 'cultural',
            'start_datetime' => '2025-11-20 10:00:00',
            'end_datetime' => '2025-11-22 18:00:00',
            'max_attendees' => 2000,
            'ticket_price' => 25.00,
            'approval_status' => 'pending'
        ],
        [
            'title' => 'Startup Pitch Competition',
            'description' => 'Young entrepreneurs pitch their innovative business ideas',
            'event_type' => 'business',
            'start_datetime' => '2025-10-30 14:00:00',
            'end_datetime' => '2025-10-30 17:00:00',
            'max_attendees' => 300,
            'ticket_price' => 15.00,
            'approval_status' => 'approved'
        ],
        [
            'title' => 'Community Health Workshop',
            'description' => 'Educational workshop on community health and wellness',
            'event_type' => 'public',
            'start_datetime' => '2025-11-05 09:00:00',
            'end_datetime' => '2025-11-05 16:00:00',
            'max_attendees' => 150,
            'ticket_price' => 0.00,
            'is_free' => true,
            'approval_status' => 'approved'
        ]
    ];
    
    $pdo->beginTransaction();
    
    foreach ($sampleEvents as $event) {
        $stmt = $pdo->prepare("
            INSERT INTO events (
                organizer_id, category_id, title, description, event_type,
                start_datetime, end_datetime, max_attendees, ticket_price,
                is_free, approval_status, created_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        
        $stmt->execute([
            6, // organizer_id (dorisanuson)
            $categoryId,
            $event['title'],
            $event['description'],
            $event['event_type'],
            $event['start_datetime'],
            $event['end_datetime'],
            $event['max_attendees'],
            $event['ticket_price'],
            $event['is_free'] ?? false,
            $event['approval_status']
        ]);
        
        echo "Added event: " . $event['title'] . "\n";
    }
    
    $pdo->commit();
    echo "Successfully added " . count($sampleEvents) . " sample events.\n";
    
} catch (Exception $e) {
    $pdo->rollBack();
    echo "Error adding sample events: " . $e->getMessage() . "\n";
}
?>
