<?php
require_once 'config/database.php';

try {
    $database = new Database();
    $conn = $database->getConnection();
    
    // Insert sample safety reports
    $sampleReports = [
        [
            'event_id' => 1,
            'reporter_id' => 3,
            'report_type' => 'security_concern',
            'severity' => 'medium',
            'title' => 'Suspicious Activity Near Main Stage',
            'description' => 'Unidentified individuals were seen loitering near the main stage area during sound check.',
            'location_description' => 'Main Stage Area, Section A',
            'incident_date' => '2024-01-15 14:30:00',
            'actions_taken' => 'Security team notified and area monitored',
            'status' => 'resolved'
        ],
        [
            'event_id' => 2,
            'reporter_id' => 4,
            'report_type' => 'medical',
            'severity' => 'high',
            'title' => 'Medical Emergency - Heat Exhaustion',
            'description' => 'Attendee collapsed due to heat exhaustion during afternoon performance.',
            'location_description' => 'VIP Section, Row 3',
            'incident_date' => '2024-02-20 15:45:00',
            'actions_taken' => 'Medical team responded, attendee treated and recovered',
            'status' => 'resolved'
        ],
        [
            'event_id' => 3,
            'reporter_id' => 5,
            'report_type' => 'facility_issue',
            'severity' => 'low',
            'title' => 'Broken Restroom Facilities',
            'description' => 'Multiple restroom stalls out of order in the east wing.',
            'location_description' => 'East Wing Restrooms, Ground Floor',
            'incident_date' => '2024-03-10 12:00:00',
            'actions_taken' => 'Maintenance team notified, temporary facilities arranged',
            'status' => 'in_progress'
        ]
    ];
    
    $stmt = $conn->prepare("
        INSERT INTO safety_reports (
            event_id, reporter_id, report_type, severity, title, description, 
            location_description, incident_date, actions_taken, status, created_at
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
    ");
    
    foreach ($sampleReports as $report) {
        $stmt->execute([
            $report['event_id'],
            $report['reporter_id'],
            $report['report_type'],
            $report['severity'],
            $report['title'],
            $report['description'],
            $report['location_description'],
            $report['incident_date'],
            $report['actions_taken'],
            $report['status']
        ]);
    }
    
    echo "✅ Sample safety reports added successfully!\n";
    echo "Added " . count($sampleReports) . " safety reports.\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
