<?php
/**
 * Add sample venues for testing the organizer dashboard
 */

require_once 'config/database.php';

// Initialize database connection
$database = new Database();
$pdo = $database->getConnection();

try {
    // Check if venues already exist
    $stmt = $pdo->query("SELECT COUNT(*) as count FROM venues");
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result['count'] > 0) {
        echo "Venues already exist. Count: " . $result['count'] . "\n";
        exit;
    }
    
    // Sample venues data
    $sampleVenues = [
        [
            'name' => 'Accra International Conference Centre',
            'type' => 'event_center',
            'address' => 'Liberation Road, Ridge, Accra',
            'city' => 'Accra',
            'region' => 'Greater Accra',
            'capacity' => 2000,
            'contact_phone' => '+233 30 266 1665',
            'contact_email' => 'info@aicc.com.gh',
            'description' => 'Premier conference and event venue in the heart of Accra'
        ],
        [
            'name' => 'Labadi Beach Hotel',
            'type' => 'hotel',
            'address' => 'Labadi Beach, Accra',
            'city' => 'Accra',
            'region' => 'Greater Accra',
            'capacity' => 500,
            'contact_phone' => '+233 30 277 2501',
            'contact_email' => 'events@labadibeach.com',
            'description' => 'Luxury beachfront hotel with excellent event facilities'
        ],
        [
            'name' => 'National Theatre of Ghana',
            'type' => 'cultural_site',
            'address' => 'Liberia Road, Accra',
            'city' => 'Accra',
            'region' => 'Greater Accra',
            'capacity' => 1500,
            'contact_phone' => '+233 30 266 1680',
            'contact_email' => 'info@nationaltheatre.gov.gh',
            'description' => 'Ghana\'s premier cultural venue for arts and entertainment'
        ],
        [
            'name' => 'Kumasi Sports Stadium',
            'type' => 'sports_facility',
            'address' => 'Bantama, Kumasi',
            'city' => 'Kumasi',
            'region' => 'Ashanti',
            'capacity' => 40000,
            'contact_phone' => '+233 32 202 4567',
            'contact_email' => 'info@kumasistadium.gh',
            'description' => 'Major sports stadium suitable for large events and concerts'
        ],
        [
            'name' => 'Cape Coast Castle',
            'type' => 'cultural_site',
            'address' => 'Victoria Park, Cape Coast',
            'city' => 'Cape Coast',
            'region' => 'Central',
            'capacity' => 300,
            'contact_phone' => '+233 33 213 2094',
            'contact_email' => 'events@capecoastcastle.gov.gh',
            'description' => 'Historic castle with unique event spaces'
        ]
    ];
    
    $pdo->beginTransaction();
    
    foreach ($sampleVenues as $venue) {
        $stmt = $pdo->prepare("
            INSERT INTO venues (
                owner_id, name, type, address, city, region, capacity,
                contact_phone, contact_email, description, created_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
        ");
        
        $stmt->execute([
            6, // owner_id (dorisanuson)
            $venue['name'],
            $venue['type'],
            $venue['address'],
            $venue['city'],
            $venue['region'],
            $venue['capacity'],
            $venue['contact_phone'],
            $venue['contact_email'],
            $venue['description']
        ]);
        
        echo "Added venue: " . $venue['name'] . "\n";
    }
    
    $pdo->commit();
    echo "Successfully added " . count($sampleVenues) . " sample venues.\n";
    
} catch (Exception $e) {
    $pdo->rollBack();
    echo "Error adding sample venues: " . $e->getMessage() . "\n";
}
?>
