<?php
/**
 * API Logs Endpoint - Returns JSON only
 */

// Set headers first
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Cache-Control: no-cache, must-revalidate');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once __DIR__ . '/../includes/api-logger.php';

try {
    $action = $_GET['action'] ?? 'get_logs';
    
    switch ($action) {
        case 'get_logs':
            $limit = min($_GET['limit'] ?? 100, 500);
            $logs = ApiLogger::getRecentLogs($limit);
            echo json_encode([
                'success' => true,
                'data' => $logs,
                'count' => count($logs)
            ]);
            break;
            
        case 'clear_logs':
            if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                $logFile = __DIR__ . '/../logs/api_calls.log';
                if (file_exists($logFile)) {
                    file_put_contents($logFile, '');
                }
                echo json_encode([
                    'success' => true,
                    'message' => 'Logs cleared successfully'
                ]);
            } else {
                http_response_code(405);
                echo json_encode([
                    'success' => false,
                    'error' => 'POST method required'
                ]);
            }
            break;
            
        case 'test':
            // Test endpoint to verify API is working
            echo json_encode([
                'success' => true,
                'message' => 'API logs endpoint is working',
                'timestamp' => date('Y-m-d H:i:s'),
                'log_file_exists' => file_exists(__DIR__ . '/../logs/api_calls.log'),
                'log_file_size' => file_exists(__DIR__ . '/../logs/api_calls.log') ? filesize(__DIR__ . '/../logs/api_calls.log') : 0
            ]);
            break;
            
        default:
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'error' => 'Invalid action'
            ]);
            break;
    }
    
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}
?>
