<?php
// Create chat uploads directory
$uploadDir = 'uploads/chat/';

if (!file_exists($uploadDir)) {
    if (mkdir($uploadDir, 0755, true)) {
        echo "Chat uploads directory created successfully at: " . realpath($uploadDir) . "\n";
    } else {
        echo "Failed to create chat uploads directory\n";
    }
} else {
    echo "Chat uploads directory already exists at: " . realpath($uploadDir) . "\n";
}

// Create .htaccess file for security
$htaccessContent = "# Prevent direct access to uploaded files
Options -Indexes
# Allow only specific file types
<FilesMatch \"\\.(jpg|jpeg|png|gif|webp|mp4|webm|mov|pdf|doc|docx|txt|zip|rar)$\">
    Order Allow,Deny
    Allow from all
</FilesMatch>
# Deny access to PHP files
<FilesMatch \"\\.php$\">
    Order Deny,Allow
    Deny from all
</FilesMatch>";

file_put_contents($uploadDir . '.htaccess', $htaccessContent);
echo "Security .htaccess file created\n";
?>
