-- Migration script to add media sharing support to simple_chat_messages table
-- Run this script to enable media sharing in chat

-- First, create the simple_chat_messages table if it doesn't exist
CREATE TABLE IF NOT EXISTS `simple_chat_messages` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `event_id` int(11) NOT NULL,
    `user_id` int(11) NOT NULL,
    `message` text NOT NULL,
    `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
    PRIMARY KEY (`id`),
    FOREIGN KEY (`event_id`) REFERENCES `events`(`id`),
    FOREIGN KEY (`user_id`) REFERENCES `users`(`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Add media support columns to simple_chat_messages table
-- Check if columns exist before adding them to avoid errors

-- Add message_type column
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE table_name = 'simple_chat_messages' 
     AND column_name = 'message_type' 
     AND table_schema = DATABASE()) = 0,
    'ALTER TABLE simple_chat_messages ADD COLUMN message_type ENUM(''text'', ''image'', ''video'', ''file'') DEFAULT ''text'' AFTER message',
    'SELECT ''Column message_type already exists'' as message'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add file_url column
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE table_name = 'simple_chat_messages' 
     AND column_name = 'file_url' 
     AND table_schema = DATABASE()) = 0,
    'ALTER TABLE simple_chat_messages ADD COLUMN file_url VARCHAR(500) NULL AFTER message_type',
    'SELECT ''Column file_url already exists'' as message'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add file_name column
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE table_name = 'simple_chat_messages' 
     AND column_name = 'file_name' 
     AND table_schema = DATABASE()) = 0,
    'ALTER TABLE simple_chat_messages ADD COLUMN file_name VARCHAR(255) NULL AFTER file_url',
    'SELECT ''Column file_name already exists'' as message'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add file_size column
SET @sql = (SELECT IF(
    (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS 
     WHERE table_name = 'simple_chat_messages' 
     AND column_name = 'file_size' 
     AND table_schema = DATABASE()) = 0,
    'ALTER TABLE simple_chat_messages ADD COLUMN file_size INT NULL AFTER file_name',
    'SELECT ''Column file_size already exists'' as message'
));
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Show the updated table structure
DESCRIBE simple_chat_messages;

-- Insert some sample media messages for testing (optional)
-- Uncomment the lines below if you want sample data

/*
INSERT INTO simple_chat_messages (event_id, user_id, message, message_type, created_at) VALUES
(1, 1, 'Welcome to the Tech Innovation Summit chat!', 'text', NOW()),
(1, 2, 'Looking forward to the event!', 'text', NOW()),
(1, 1, 'Shared an image', 'image', NOW());
*/

SELECT 'Media chat migration completed successfully!' as status;
