<?php
require_once 'config/database.php';

try {
    $db = new Database();
    $conn = $db->getConnection();
    
    // Check user and role data
    $query = "SELECT u.id, u.username, u.email, u.full_name, u.status, ur.role_type 
              FROM users u 
              LEFT JOIN user_roles ur ON u.id = ur.user_id 
              WHERE u.username = 'feliciaayensu' OR u.email = 'feliciaayensu'";
    
    $stmt = $conn->prepare($query);
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    echo "<h2>User Debug Information</h2>";
    if ($user) {
        echo "<pre>";
        print_r($user);
        echo "</pre>";
        
        // If no role assigned, assign tourist role
        if (!$user['role_type']) {
            echo "<h3>No role assigned. Assigning tourist role...</h3>";
            
            $insertRole = "INSERT INTO user_roles (user_id, role_type, role_level, permissions, assigned_by) 
                          VALUES (?, 'tourist', 'local', '[]', 1)";
            $roleStmt = $conn->prepare($insertRole);
            
            if ($roleStmt->execute([$user['id']])) {
                echo "<p style='color: green;'>Tourist role assigned successfully!</p>";
            } else {
                echo "<p style='color: red;'>Failed to assign role.</p>";
            }
        }
        
        // Also update user status to active if pending
        if ($user['status'] !== 'active') {
            echo "<h3>Updating user status to active...</h3>";
            
            $updateStatus = "UPDATE users SET status = 'active' WHERE id = ?";
            $statusStmt = $conn->prepare($updateStatus);
            
            if ($statusStmt->execute([$user['id']])) {
                echo "<p style='color: green;'>User status updated to active!</p>";
            } else {
                echo "<p style='color: red;'>Failed to update status.</p>";
            }
        }
        
    } else {
        echo "<p style='color: red;'>User not found!</p>";
    }
    
    // Show all users and their roles for debugging
    echo "<h2>All Users and Roles</h2>";
    $allQuery = "SELECT u.id, u.username, u.email, u.status, ur.role_type 
                 FROM users u 
                 LEFT JOIN user_roles ur ON u.id = ur.user_id 
                 ORDER BY u.id";
    
    $allStmt = $conn->prepare($allQuery);
    $allStmt->execute();
    $allUsers = $allStmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Status</th><th>Role Type</th></tr>";
    
    foreach ($allUsers as $u) {
        echo "<tr>";
        echo "<td>{$u['id']}</td>";
        echo "<td>{$u['username']}</td>";
        echo "<td>{$u['email']}</td>";
        echo "<td>{$u['status']}</td>";
        echo "<td>" . ($u['role_type'] ?? 'NO ROLE') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>
