<?php
// Simple directory creation script - no dependencies
// This script creates required directories without loading any other files

// Turn on error reporting to see what's happening
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Creating Required Directories</h1>";

$directories = [
    'logs',
    'uploads',
    'uploads/events',
    'uploads/venues', 
    'uploads/users',
    'cache',
    'temp'
];

foreach ($directories as $dir) {
    $fullPath = __DIR__ . '/' . $dir;
    
    if (!is_dir($fullPath)) {
        if (mkdir($fullPath, 0755, true)) {
            echo "<p style='color: green;'>✅ Created: $dir</p>";
        } else {
            echo "<p style='color: red;'>❌ Failed to create: $dir</p>";
        }
    } else {
        echo "<p style='color: blue;'>ℹ️ Already exists: $dir</p>";
    }
}

echo "<h2>Testing Basic PHP</h2>";
echo "<p>PHP Version: " . phpversion() . "</p>";
echo "<p>Current Directory: " . __DIR__ . "</p>";
echo "<p>Script completed successfully!</p>";

echo "<p><a href='index.html'>Go to Homepage</a> | <a href='debug.php'>Test Debug Page</a></p>";
?>
