<?php
/**
 * Test the debug API logs endpoint directly
 */

require_once __DIR__ . '/includes/api-logger.php';

echo "Testing debug endpoint...\n\n";

// Test getting logs directly
$logs = ApiLogger::getRecentLogs(10);
echo "Direct ApiLogger call result:\n";
echo "Number of logs: " . count($logs) . "\n";

if (count($logs) > 0) {
    echo "Sample log entry:\n";
    print_r($logs[0]);
}

echo "\nTesting JSON encoding:\n";
$json = json_encode($logs);
echo "JSON length: " . strlen($json) . " characters\n";
echo "JSON preview: " . substr($json, 0, 200) . "...\n";

echo "\nTesting file access:\n";
$logFile = __DIR__ . '/logs/api_calls.log';
echo "Log file exists: " . (file_exists($logFile) ? 'yes' : 'no') . "\n";
echo "Log file size: " . (file_exists($logFile) ? filesize($logFile) : 0) . " bytes\n";
echo "Log file readable: " . (is_readable($logFile) ? 'yes' : 'no') . "\n";

if (file_exists($logFile)) {
    $content = file_get_contents($logFile);
    echo "Raw file content preview:\n";
    echo substr($content, 0, 300) . "\n";
}
?>
