<?php
// Test script for organizer dashboard APIs
require_once 'config/database.php';
require_once 'includes/auth.php';

// Test login first to get token
function testLogin() {
    $loginData = [
        'email' => 'dorisanuson@example.com',
        'password' => 'password123'
    ];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://localhost:8080/api/auth.php/login');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($loginData));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "Login Test:\n";
    echo "HTTP Code: $httpCode\n";
    echo "Response: $response\n\n";
    
    $data = json_decode($response, true);
    return $data['token'] ?? null;
}

// Test organizer stats endpoint
function testOrganizerStats($token) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://localhost:8080/api/events.php?action=organizer-stats');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $token
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "Organizer Stats Test:\n";
    echo "HTTP Code: $httpCode\n";
    echo "Response: $response\n\n";
}

// Test organizer events endpoint
function testOrganizerEvents($token) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://localhost:8080/api/events.php?action=organizer-events');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $token
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "Organizer Events Test:\n";
    echo "HTTP Code: $httpCode\n";
    echo "Response: $response\n\n";
}

// Test notifications endpoint
function testNotifications($token) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, 'http://localhost:8080/api/notifications.php?action=list');
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $token
    ]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    
    echo "Notifications Test:\n";
    echo "HTTP Code: $httpCode\n";
    echo "Response: $response\n\n";
}

// Run tests
echo "=== Testing Organizer Dashboard APIs ===\n\n";

$token = testLogin();

if ($token) {
    testOrganizerStats($token);
    testOrganizerEvents($token);
    testNotifications($token);
} else {
    echo "Failed to get authentication token. Cannot proceed with API tests.\n";
}

echo "=== Test Complete ===\n";
?>
